﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3				// Use modern global access method and strict wave access
#pragma hide=1

// uncomment to debug
//#define DEBUG

// show the threshold image in the split window
Function T2_ShowMasked()

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile
	
	string msfile, dlist
	variable which
	
	msfile = cwfile[4,inf] + "_msk"
	dlist = f_LoimgF()
	which = WhichListItem(msfile,dlist) + 2
	disp_SplitWindow(which)
	disp_UpdateControlBar()
	return 0
end

Function/S f_LoMaskOptions()

	string rtstr = "Use Drawing Tools;\\M1(-;"
	
	if (f_hasMQ())
		rtstr += "[>RoI<];RoI<[ ]>RoI;"
	else
		rtstr += "\\M0:(:[>RoI<];\\M0:(:RoI<[ ]>RoI;"
	endif
	
	if (f_ThresholdExists()>0)
		rtstr += "\\M1(-;Threshold Maxima;"
	else
		rtstr += "\\M1(-;\\M1(Threshold Maxima;"
	endif
	
	if (f_FillExists()>0)
		rtstr += "Fill Maxima;"
	else
		rtstr += "\\M1(Fill Maxima;;"
	endif
	
	return rtstr
end

Function/S f_LoMaskLevels()

	string rtstr = "Value;Masked Region Average;"
	
	if (f_hasMQ())
		rtstr += "RoI Average;"
	else
		rtstr += "\\M1(RoI Average;"
	endif
	
	return rtstr
end

// ***
// FUNCTIONS

// draw tab23 - mask
Function disp_Tab23Draw(pwidth,pheight, ptabpos)
	variable pwidth, pheight, ptabpos

	variable tvoffset, dtvoffset = 30

	tvoffset = ptabpos + 1.8*dtvoffset

	PopupMenu popupMaskOPHow_tab23,pos={20,tvoffset},size={120,23},title="RoI", proc=X_PopMenuProc
	PopupMenu popupMaskOPHow_tab23,mode=1,value=#"f_LoMaskOptions()",popvalue="Use Drawing Tools",disable=1
	
	//tvoffset += 0.8*dtvoffset
	
	Button buttonstartRoIMask_tab23,pos={220,tvoffset},size={40,20},proc=X_ButtonProc,title="Start"
	Button buttonstartRoIMask_tab23,userdata="start",disable=1,help={"Start using the drawing tools."}
	Button buttonstopRoIMask_tab23,pos={270,tvoffset},size={40,20},proc=X_ButtonProc,title="Stop"
	Button buttonstopRoIMask_tab23,userdata="stop",disable=1,help={"Stop using the drawing tools."}
	Button buttonclearRoIMask_tab23,pos={320,tvoffset},size={40,20},proc=X_ButtonProc,title="Clear",disable=1

	tvoffset += dtvoffset

	PopupMenu popupMaskOPLevel_tab23,pos={20,tvoffset},size={120,23},title="Set Outside RoI", proc=X_PopMenuProc
	PopupMenu popupMaskOPLevel_tab23,mode=1,value=#"f_LoMaskLevels()",popvalue="At Value",disable=1

	SetVariable setvarMaskOPLevel_tab23,pos={240,tvoffset},size={60,25},title="",limits={-inf,inf,1},value=_NUM:0, disable=1

	tvoffset += 2.8*dtvoffset

	Button buttonDoMaskOP_tab23,pos={pwidth-85,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Apply",disable=1

	return 0
end

// update tab process - mask regions
Function disp_updateTab23()
		
	STRUCT S_MaskOPParams mop
	Sf_GetMaskOPParams(mop)
	
	variable setstate
	
	setstate = ((mop.how == 7) && (f_FillExists() < 0))
	setstate += ((mop.how == 6) && (f_ThresholdExists() < 0))
	setstate += (((mop.how == 4) || (mop.how == 3)) && (f_HasMaskRoI() == 0))
	if (setstate > 0)
		mop.how = 1
		PopupMenu popupMaskOPHow_tab23, win=$k_fullPanel, mode=1
	endif
	// Mask Regions
	if (mop.how == 1)
		if (f_ShowToolsState() > 0)
			Button buttonstartRoIMask_tab23, win=$k_fullPanel, disable=2
			Button buttonstopRoIMask_tab23, win=$k_fullPanel, disable=0
			Button buttonclearRoIMask_tab23,win=$k_fullPanel, disable=2
			PopupMenu popupMaskOPLevel_tab23,win=$k_fullPanel, disable=2
			ControlInfo/W=$k_fullPanel popupMaskOPLevel_tab23
			if (v_value > 1)
				SetVariable setvarMaskOPLevel_tab23,win=$k_fullPanel, disable=1
			else
				SetVariable setvarMaskOPLevel_tab23,win=$k_fullPanel, disable=2
			endif
			Button buttonDoMaskOP_tab23,win=$k_fullPanel, disable=2
			return 0
		endif
		T2_ValidateMaskRoIDrawings()
		if (f_HasMaskRoI())
			Button buttonstartRoIMask_tab23, win=$k_fullPanel, disable=2
			Button buttonstopRoIMask_tab23, win=$k_fullPanel, disable=2
			Button buttonclearRoIMask_tab23,win=$k_fullPanel, disable=0
			PopupMenu popupMaskOPLevel_tab23,win=$k_fullPanel, disable=0
			ControlInfo/W=$k_fullPanel popupMaskOPLevel_tab23
			if (v_value > 1)
				SetVariable setvarMaskOPLevel_tab23,win=$k_fullPanel, disable=1
			else
				SetVariable setvarMaskOPLevel_tab23,win=$k_fullPanel, disable=0
			endif
			Button buttonDoMaskOP_tab23,win=$k_fullPanel, disable=0
		else
			Button buttonstartRoIMask_tab23, win=$k_fullPanel, disable=0
			Button buttonstopRoIMask_tab23, win=$k_fullPanel, disable=2
			Button buttonclearRoIMask_tab23,win=$k_fullPanel, disable=2
			PopupMenu popupMaskOPLevel_tab23,win=$k_fullPanel, disable=2
			ControlInfo/W=$k_fullPanel popupMaskOPLevel_tab23
			if (v_value > 1)
				SetVariable setvarMaskOPLevel_tab23,win=$k_fullPanel, disable=1
			else
				SetVariable setvarMaskOPLevel_tab23,win=$k_fullPanel, disable=2
			endif
			Button buttonDoMaskOP_tab23,win=$k_fullPanel, disable=2
		endif
	else
		Button buttonstartRoIMask_tab23,win=$k_fullPanel, disable=2
		Button buttonstopRoIMask_tab23,win=$k_fullPanel, disable=2
		Button buttonclearRoIMask_tab23,win=$k_fullPanel, disable=2
		PopupMenu popupMaskOPLevel_tab23,win=$k_fullPanel, disable=0
		Button buttonDoMaskOP_tab23,win=$k_fullPanel, disable=0
		ControlInfo/W=$k_fullPanel popupMaskOPLevel_tab23
		if (v_value > 1)
			SetVariable setvarMaskOPLevel_tab23,win=$k_fullPanel, disable=1
		else
			SetVariable setvarMaskOPLevel_tab23,win=$k_fullPanel, disable=0
		endif
	endif
	
	return 0
end

// start drawing tools
Function T2_startmaskdrawing()

	// remove controlbar
	disp_UpdateControlBar(allstate=1)
	// open tools
	SetDrawLayer/W=$k_imgDisplay ProgFront
	SetDrawEnv/W=$k_imgDisplay linefgc=(65535,65535,65535), fillpat=0, linethick=2, xcoord=top,ycoord=left, save
	SetDrawEnv/W=$k_imgDisplay gstart, gname=MaskRoIs
	ShowTools/W=$k_imgDisplay arrow
	
	return 0
end

// stop drawing tools
Function T2_stopmaskdrawing()
	
	// close tools
	SetDrawEnv/W=$k_imgDisplay gstop
	GraphNormal/W=$k_imgDisplay
	HideTools/W=$k_imgDisplay
	// restore controlbar
	ControlBar/W=$k_imgDisplay cbheight
	disp_UpdateControlBar(allstate=0)
	DoUpdate/W=$k_imgDisplay
	
	return 0
end

Static Function T2_ValidateMaskRoIDrawings()

	string fstr = ""
	DrawAction/W=$k_imgDisplay getgroup=MaskRoIs, commands
	if (V_flag > 0)
		fstr = ListMatch(S_recreation,"Draw*","\r\t")
		if (strlen(fstr) == 0)
			T2_ClearMaskRoIs()
			Button buttonclearRoIMask_tab23,win=$k_fullPanel, disable=2
		else
			Button buttonclearRoIMask_tab23,win=$k_fullPanel, disable=0
		endif
	endif
	killvariables/Z v_startPos, v_endPos, v_flag
	return 0
end

// stop drawing tools
Function T2_ClearMaskRoIs()

	DrawAction/W=$k_imgDisplay getgroup=MaskRoIs
	DrawAction/W=$k_imgDisplay delete=v_startPos,v_EndPos
	DrawAction/W=$k_imgDisplay getgroup=_all_
	DrawAction/W=$k_imgDisplay delete=v_startPos,v_EndPos
	DrawAction/L=ProgFront/W=$k_imgDisplay delete
	return 0
end

// create the RoI mask
Function T2_DoMaskOP()

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile
	
	variable np
	
	// wave for result
	string theMaskName = cwfile + "_msk"
	string theFill

	DFREF cdf = GetDataFolderDFR()
		
	STRUCT S_MaskOPParams mop
	Sf_GetMaskOPParams(mop)

	DFREF idf = $(f_wdfstr(0))
	SetDataFolder idf
	
	// source files
	wave theImage = $cwfile

	// create a free mask image for the operation
	if (f_IsStack())
		np = f_PlaneNumber()
		MatrixOP/FREE tomask = layer(theImage,np)
		CopyScales theImage tomask
	else
		duplicate/FREE theImage, tomask
	endif

	// roi mask?
	switch(mop.how)
		case 1:		// from drawing tools
			ImageGenerateROIMask/W=$k_imgDisplay $cwfile
			wave M_ROIMask
			if (f_IsStack())
				MatrixOP/FREE theMaskSource = layer(M_ROIMask,np)
				CopyScales theImage theMaskSource
			else
				duplicate/FREE M_ROIMask theMaskSource
			endif
			killwaves/Z M_ROIMask
			break
		case 3:		// inside marquee rectangle
		case 4:		// outside marquee rectangle
			
			STRUCT S_MarqueeCoordinates smc
			Sf_GetMQCoordinates(smc)
			switch(mop.how)
				case 3:
					wave theMaskSource = generate_RoIMask(tomask, smc, 1, 2)
					break
				case 4:
					wave theMaskSource = generate_RoIMask(tomask, smc, 2, 2)
					break
				endswitch
			break

		case 6:		// threshold
			theFill = StringFromList(f_ThresholdExists(),f_LoimgF(full=1,all=1))
			wave theMaskThreshold = $theFill
			if (f_IsStack())
				MatrixOP/FREE theMaskSource = layer(theMaskThreshold,np)
				CopyScales theImage theMaskSource
			else
				duplicate/FREE theMaskThreshold theMaskSource
			endif
			theMaskSource/=255
			break
		case 7:		// fill
			theFill = StringFromList(f_FillExists(),f_LoimgF(full=1,all=1))
			wave theMaskFill = $theFill
			if (f_IsStack())
				MatrixOP/FREE theMaskSource = layer(theMaskFill,np)
				CopyScales theImage theMaskSource
			else
				duplicate/FREE theMaskFill theMaskSource
			endif
			theMaskSource/=255
			break
	endswitch

	// create the masked result
	Duplicate/FREE theMaskSource theMask
	MatrixOP/FREE masked = theMask*toMask
	CopyScales theImage, masked
	
	switch(mop.level)
		case 1:	// at value other than zero (default for theMask)
			if (mop.value != 0)
				masked = theMask==0 ? mop.value : masked
			endif
			break
		case 2:	// at mask region average
			MatrixOP/O/FREE iMask = 1 - theMask
			Redimension/D iMask
			iMask = iMask==0 ? NaN : iMask
			MatrixOP/O/FREE iT = iMask*toMask	
			ImageStats/Q iT
			masked = theMask==0 ? V_avg : masked			
			break
		case 3:	// at ROI average
			// generate mask
			if (f_hasMQ())
				STRUCT S_MarqueeCoordinates mc
				Sf_GetMQCoordinates(mc)
				ImageStats/Q/G={mc.pgrleft,mc.pgrright,mc.pgrtop,mc.pgrbottom} toMask
				masked = theMask==0 ? V_avg : masked			
			endif
			break
	endswitch

	// put back the mask result
	if (f_IsStack())
		wave/Z theMasked = $theMaskName
		if (!WaveExists(theMasked))
			duplicate/O theImage $theMaskName
			wave theMasked = $theMaskName
			theMasked = 0
			ImageTransform/D=masked/P=(np) setPlane theMasked
			theMaskName += "_src"	
			duplicate/O theImage $theMaskName
			wave theMasked = $theMaskName
			theMasked = 0
			ImageTransform/D=themask/P=(np) setPlane theMasked
		else
			// assure that the mask is fp64
			if ((WaveType($theMaskName) & 0x80) != 1)
				Redimension/D theMasked
			endif
			ImageTransform/D=masked/P=(np) setPlane theMasked
			theMaskName += "_src"	
			wave theMasked = $theMaskName
			ImageTransform/D=theMask/P=(np) setPlane theMasked			
		endif
	else
		duplicate/O masked, $theMaskName
		theMaskName += "_src"	
		duplicate/O theMask $theMaskName
	endif
	
	// store the threshold mask
	
	SetDataFolder cdf
	
	return 0
end

// generate an RoI mask from wimg
// mc: marquee coordinates (if needed)
// how: 1 RoI mask inside; 2 RoI mask outside
// which: 0 histogram (0/64), 1 threshold (0/64), 2 mask (0/1), 3 crop (NaN,1)
Function/WAVE generate_RoIMask(wimg, mc, how, which)
	wave wimg
	STRUCT S_MarqueeCoordinates &mc
	variable how, which

	variable rtn = 0, roi, mask, npts, ic
	variable ppx0, ppx1, ppy0, ppy1
//	variable left, top
	
	switch(which)
		case 0:	// histogram
		case 1:		// threshold
			roi = 0
			mask = 64
			break
		case 2:	// raw mask
			roi = 1
			mask = 0
			break
		case 3:	// crop mask
			roi = 1
			mask = NaN
			break
	endswitch
	
//	left = DimOffset(wimg,0)
//	top = DimOffset(wimg,1)
	
	// put trunated graph coordinates in local variables
	ppx0 = ScaleToIndex(wimg,mc.pgleft,0)
	if (ppx0 < 0)
		ppx0 = 0
	endif
	ppx1 = ScaleToIndex(wimg,mc.pgright,0) - 1
	ppy0 = ScaleToIndex(wimg,mc.pgtop,1)
	if (ppy0 < 0)
		ppy0 = 0
	endif
	ppy1 = ScaleToIndex(wimg,mc.pgbottom,1)-1

	// store RoI values for the displayed image
	duplicate/FREE wimg mwimg
//	wave imgMask = mwimg
	switch(which)
		case 3:
			Redimension/D mwimg
			break
		default:
			if (WaveDims(wimg) == 3)
				Redimension/B/U/N=(-1,-1,1) mwimg
			else
				Redimension/B/U mwimg
			endif
			break
	endswitch
	// generate RoI ... all image of interest
	switch(how)
		case 1:		// RoI inside
			mwimg = mask
			mwimg[ppx0,ppx1][ppy0,ppy1] = roi
			break
		case 2:		// RoI outside
			mwimg = roi
			mwimg[ppx0,ppx1][ppy0,ppy1] = mask
			break
	endswitch

	return mwimg
end
